/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ActionRemoveBrewingRecipeByInput
extends ActionBrewingBase {
    private final IItemStack input;
    private final List<IBrewingRecipe> removedRecipes = new ArrayList<IBrewingRecipe>();

    public ActionRemoveBrewingRecipeByInput(List<IBrewingRecipe> recipes, IItemStack input) {
        super(recipes);
        this.input = input;
    }

    @Override
    public void apply() {
        Iterator registryIterator = this.recipes.iterator();
        while (registryIterator.hasNext()) {
            IBrewingRecipe next = (IBrewingRecipe)registryIterator.next();
            if (!next.isInput(this.input.getInternal())) continue;
            this.removedRecipes.add(next);
            registryIterator.remove();
        }
    }

    @Override
    public void undo() {
        this.removedRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + this.input;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + this.input;
    }
}

